using System;
using System.IO;
using DynaPDF;

namespace signature_ap
{
	class Signature_AP
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diCreator, "C# test application");
            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diTitle, "Custom digital signature appearance");

            pdf.Append();
            pdf.SetFont("Arial", DynaPDF.TFStyle.fsNone, 14.0, true, DynaPDF.TCodepage.cp1252);
            pdf.WriteFText(DynaPDF.TTextAlign.taLeft, "This file is digitally signed with a self sign certificate." +
            "The appearance of the signature field is created with normal DynaPDF functions. However, it " +
            "would also be possible to import a PDF page, an EMF file, or an image into the " +
            "appearance template.\n\n" +
            "When creating an individual signature appearance make sure to place the validation icon " +
            "properly with PlaceSigFieldValidateIcon(). The appearance of the validation icon " +
            "depends on the Acrobat version with which the file is opened. However, the unscaled size " +
            "of that icon is always 100.0 x 100.0 Units. It can be scaled to every size you want " +
            "but it is usually best to preserve the aspect ratio and the icon must be placed fully " +
            "inside the appearance template.");

            /* ---------------------- Signature field appearance ---------------------- */

            int sigField = pdf.CreateSigField("Signature", -1, 200.0, 500.0, 200.0, 80.0);
            pdf.SetFieldColor(sigField, DynaPDF.TFieldColor.fcBorderColor, DynaPDF.TPDFColorSpace.csDeviceRGB, CPDF.NO_COLOR);
            // Place the validation icon on the left side of the signature field.
            pdf.PlaceSigFieldValidateIcon(sigField, 0.0, 15.0, 50.0, 50.0);
            /*
               This function creates a template into which you can draw whatever you want. The template
               is already opened when calling the function; it must be closed when finish with EndTemplate().
               An appearance template of a signature field is reserved for this field. It must not be placed
               on another page!

               In addition, it makes no sense to create an appearance template when the file is not digitally
               signed later. Empty signature fields cannot contain a user defined appearance.
            */
            pdf.CreateSigFieldAP(sigField);

            pdf.SaveGraphicState();
            pdf.Rectangle(0.0, 0.0, 200.0, 80.0, DynaPDF.TPathFillMode.fmNoFill);
            pdf.ClipPath(DynaPDF.TClippingMode.cmWinding, DynaPDF.TPathFillMode.fmNoFill);
            int sh = pdf.CreateAxialShading(0.0, 0.0, 200.0, 0.0, 0.5, pdf.RGB(120, 120, 220), CPDF.PDF_WHITE, true, true);
            pdf.ApplyShading(sh);
            pdf.RestoreGraphicState();

            pdf.SaveGraphicState();
            pdf.Ellipse(50.5, 1.0, 148.5, 78.0, DynaPDF.TPathFillMode.fmNoFill);
            pdf.ClipPath(DynaPDF.TClippingMode.cmWinding, DynaPDF.TPathFillMode.fmNoFill);
            sh = pdf.CreateAxialShading(0.0, 0.0, 0.0, 78.0, 2.0, CPDF.PDF_WHITE, pdf.RGB(120, 120, 220), true, true);
            pdf.ApplyShading(sh);
            pdf.RestoreGraphicState();

            pdf.SetFont("Arial", DynaPDF.TFStyle.fsBold | DynaPDF.TFStyle.fsUnderlined, 11.0, true, DynaPDF.TCodepage.cp1252);
            pdf.SetFillColor(pdf.RGB(120, 120, 220));
            pdf.WriteFTextEx(50.0, 60.0, 150.0, -1.0, DynaPDF.TTextAlign.taCenter, "Digitally signed by:");
            pdf.SetFont("Arial", DynaPDF.TFStyle.fsBold | DynaPDF.TFStyle.fsItalic, 18.0, true, DynaPDF.TCodepage.cp1252);
            pdf.SetFillColor(pdf.RGB(100, 100, 200));
            pdf.WriteFTextEx(50.0, 45.0, 150.0, -1.0, DynaPDF.TTextAlign.taCenter, "DynaPDF");

            pdf.EndTemplate(); // Close the appearance template.

            /* ------------------------------------------------------------------------ */

            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseAndSignFile("../../../test_files/test_cert.pfx", "123456", "Test", null))
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
         }
         Console.Read();
		}
	}
}
